<?php include "config.php"; ?>
<!DOCTYPE html>
<html amp>
<head>
    <meta charset="utf-8">

    <script async="" src="https://cdn.ampproject.org/v0.js"></script>
    <title><?php echo $meta_title; ?></title>
    <meta content="<?php echo $meta_author; ?>" name="author">
    <meta content="<?php echo $meta_description; ?>" name="description">
    <meta content="<?php echo $meta_keywords; ?>" name="keywords">
    <link rel="canonical" href="<?php echo $meta_canonical; ?>">
    <meta name="viewport" content="width=device-width,minimum-scale=1,initial-scale=1">
        <style amp-custom>
        body {
            background-image: url(assets/bg.jpg);
            background-size: cover;
            background-position: left top;
            padding: 0;
        }

        body .container {
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-direction: column;
            position: relative;
        }

        .pageskin {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
        }

        .pageskin a {
            display: block;
            width: 100%;
            height: 100%;
        }

        .button-container {
            display: flex;
            justify-content: center;
            flex-direction: column;
            align-items: center;
            gap: 25px;
            z-index: 2;
            position: relative;
            transform: translateY(55%);
        }

        a.button {
            display: block;
            height: 5vh;
            width: 27vh;
        }

        a.button img {
            width: 100%;
            height: auto;
        }

        a.button-bottom {
            position: absolute;
            bottom: 3%;
            left: 50%;
            transform: translateX(-50%);
            z-index: 2;
        }
    </style>
    <style amp-boilerplate>
        body {
            -webkit-animation: -amp-start 8s steps(1, end) 0s 1 normal both;
            -moz-animation: -amp-start 8s steps(1, end) 0s 1 normal both;
            -ms-animation: -amp-start 8s steps(1, end) 0s 1 normal both;
            animation: -amp-start 8s steps(1, end) 0s 1 normal both
        }

        @-webkit-keyframes -amp-start {
            from {
                visibility: hidden
            }
            to {
                visibility: visible
            }
        }

        @-moz-keyframes -amp-start {
            from {
                visibility: hidden
            }
            to {
                visibility: visible
            }
        }

        @-ms-keyframes -amp-start {
            from {
                visibility: hidden
            }
            to {
                visibility: visible
            }
        }

        @-o-keyframes -amp-start {
            from {
                visibility: hidden
            }
            to {
                visibility: visible
            }
        }

        @keyframes -amp-start {
            from {
                visibility: hidden
            }
            to {
                visibility: visible
            }
        }
    </style><noscript><style amp-boilerplate>body{-webkit-animation:none;-moz-animation:none;-ms-animation:none;animation:none}</style></noscript>
</head>

<body class="amp-dark-mode amp-mode-mouse" style="opacity: 1; visibility: visible; animation: auto ease 0s 1 normal none running none;">
        <div class="container">
        <div class="pageskin"><a href="<?php echo $yonlen_url; ?>"></a></div>
        <amp-img src="assets/logo.png" width="294" height="60" alt="Mevzuspor"></amp-img>
        <div class="button-container mobile">
            <a href="<?php echo $site_giris_buton; ?>" class="button"><amp-img src="assets/giris-btn.png" layout="responsive" alt="Site Giriş" width="320" height="75"></amp-img></a>
            <a href="<?php echo $twitter_buton; ?>" class="button"><amp-img src="assets/twitter-btn.png" layout="responsive" alt="Twitter" width="320" height="75"></amp-img></a>
        </div>
    </div>
</body>

</html>